<?php

namespace Drupal\per_domain_fields\Plugin\DataType;

use Drupal\Core\TypedData\TypedDataInterface;

/**
 * Represents TypedData that stores a value per-domain.
 */
interface PerDomainTypedDataInterface extends TypedDataInterface {

  /**
   * Return all domain values.
   *
   * This is useful as the usual ::getValue() method only returns values
   * for the active domain.
   *
   * @return array<string, mixed>
   *   Keys are domain IDs, values are field values.
   */
  public function getValueForAllDomains(): array;

  /**
   * Sets all domain values in one go.
   *
   * @param array<string, mixed> $value
   *   Keys are domain IDs, values are field values.
   * @param bool $notify
   *   (optional) Whether to notify the parent object of the change. Defaults to
   *   TRUE. If a property is updated from a parent object, set it to FALSE to
   *   avoid being notified again.
   */
  public function setValueForAllDomains(array $value, $notify = TRUE);

  /**
   * Overrides what the active domain ID is when getting/setting values.
   *
   * @param string $activeDomainId
   *   A domain ID. This is not validated.
   */
  public function setActiveDomainId(string $activeDomainId);

  /**
   * Removes the override set by some earlier call to setActiveDomainId().
   */
  public function unsetActiveDomainId();

}
