<?php

namespace Drupal\per_domain_fields\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\Plugin\Field\FieldType\BooleanItem;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines the `per_domain_boolean` type.
 */
#[FieldType(
  id: "per_domain_boolean",
  label: new TranslatableMarkup("Boolean [Per-domain]"),
  description: new TranslatableMarkup("Field to store a true or false value. Secretly stores a value per-domain, but hides this on the front-end, showing the value that corresponds to the Active domain only except on edit forms."),
  default_widget: "per_domain_boolean_checkbox",
  default_formatter: "per_domain_boolean"
)]
class PerDomainBooleanItem extends BooleanItem {
  use PerDomainFieldTypeTrait;

}
