<?php

namespace Drupal\per_domain_fields;

/**
 * Shared code for getting and setting an overridable active domain ID.
 */
trait LoadsOverridableActiveDomainIdTrait {

  /**
   * The active Domain ID override set by some caller.
   *
   * @var string|null
   */
  protected ?string $activeDomainId = NULL;

  /**
   * {@inheritDoc}
   */
  public function setActiveDomainId(string $activeDomainId) {
    $this->activeDomainId = $activeDomainId;
  }

  /**
   * {@inheritDoc}
   */
  public function unsetActiveDomainId() {
    unset($this->activeDomainId);
  }

  /**
   * Helper that returns the currently active domain ID.
   *
   * @return string|null
   *   If no active domain ID could be ascertained, NULL is returned.
   */
  private function getActiveDomainId(): ?string {
    if (isset($this->activeDomainId)) {
      return $this->activeDomainId;
    }
    return \Drupal::service('domain.negotiator')->getActiveId() ?: NULL;
  }

}
