<?php

namespace Drupal\per_domain_fields\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\Plugin\Field\FieldWidget\NumberWidget;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'per_domain_number' widget.
 */
#[FieldWidget(
  id: 'per_domain_number',
  label: new TranslatableMarkup('Number field [All domain values]'),
  field_types: [
    'per_domain_integer',
    'per_domain_decimal',
    'per_domain_float',
  ],
)]
class PerDomainNumberWidget extends NumberWidget {
  use PerDomainFieldWidgetTrait{
    formElement as formElementGeneral;
  }

  /**
   * {@inheritDoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    // Core's number widget hard-codes field type IDs. Fix to work with ours.
    switch ($this->fieldDefinition->getType()) {
      case 'per_domain_decimal':
        $element['#step'] = pow(0.1, $this->getFieldSettings()['scale']);
        break;

      case 'per_domain_float':
        $element['#step'] = 'any';
        break;
    }

    return $this->formElementGeneral($items, $delta, $element, $form, $form_state);
  }

}
