# Permission Search

Search and explore Drupal permissions efficiently.  
Quickly find permissions by keyword or open module-specific permission pages instead of loading the entire permissions screen.

---

## 🧩 Overview

**Permission Search** improves the Drupal administrator experience by replacing the heavy `/admin/people/permissions` page with a fast, focused search and navigation tool.

This module provides a single, lightweight form that allows administrators to:

- 🔍 **Search** for permissions by name or description, using keywords or wildcard masks (`*`, `?`).
- 📂 **Jump directly** to the permissions page of a specific module.
- 🧭 Use a **single “Go” button** to either display search results or open the module permissions page.
- ⚡ Avoid rendering hundreds of checkboxes at once — perfect for large sites.
- 🧱 Browse modules grouped by *Core* and *Contrib/Custom* categories.
- 🛡️ Safely display formatted titles and descriptions with HTML markup (e.g., `<em>` placeholders).

---

## 📦 Requirements

- **Drupal core:** `^10.3` or `^11`
- **PHP:** `8.1` or higher  
- No additional modules or external libraries required.

---

## ⚙️ Installation

1. Install as you would any other contributed module:

   ```bash
   composer require drupal/permission_search
   drush en permission_search -y
   drush cr
   ```

2. Log in as a user with the **“administer permissions”** permission.

3. Open the module page at:

   ```
   /admin/people/permissions/search
   ```

   or go to **People → Permission Search** in the admin menu.

---

## 🚀 Usage

1. **Search by permission name or description**  
   Enter a keyword or wildcard mask (e.g., `menu`, `administer *`, `delete ?`) in the text field and click **Go**.  
   Matching permissions will appear in a table showing the ID, title, description, and provider module.

2. **Open module permissions**  
   Instead of searching, select a module from the dropdown and click **Go**.  
   You’ll be redirected to that module’s permissions page.

3. **No input selected**  
   If both fields are empty, you’ll get a helpful message prompting you to search or select a module.

---

## 🧭 Configuration

No configuration is required.  
All features are available immediately after enabling the module.  
Only users with the core **administer permissions** capability can access the interface.

---

## 🧰 Example Use Cases

- Large Drupal sites with dozens of enabled modules.  
- Developers or auditors checking which module defines a specific permission.  
- Site builders searching for “menu”, “node”, “export”, etc. without scrolling through hundreds of checkboxes.

---

## 🔧 Recommended Modules

Optional modules that improve usability:

- [Admin Toolbar](https://www.drupal.org/project/admin_toolbar) – easier navigation to People → Permission Search.  
- [Coffee](https://www.drupal.org/project/coffee) or [Gin Toolbar Search](https://www.drupal.org/project/gin_toolbar_search) – quickly open the search form by typing “perm”.

---

---

## 🧑‍💻 Maintainers

- **Primary maintainer:** [kretch](https://www.drupal.org/u/kretch)

Contributions and feedback are welcome in the project issue queue.

---

## 📄 License

This module is distributed under the terms of the [GNU General Public License, version 2 or later](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html).

---

## 🧠 Project Links

- **Project page:** [https://www.drupal.org/project/permission_search](https://www.drupal.org/project/permission_search)  
- **Issue queue:** [https://www.drupal.org/project/issues/permission_search](https://www.drupal.org/project/issues/permission_search)  
- **Composer package:** `drupal/permission_search`

---
