<?php

declare(strict_types=1);

namespace Drupal\permission_turbo\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Permissions Turbo settings for this site.
 */
class PermissionTurboSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'permission_turbo_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['permission_turbo.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('permission_turbo.settings');

    $form['replace_core'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Replace core permission page'),
      '#description' => $this->t('When enabled, the enhanced permission page will replace the default Drupal permissions page.'),
      '#default_value' => $config->get('replace_core') ?? TRUE,
    ];

    $form['auto_expand_search'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Auto-expand matching providers on search'),
      '#description' => $this->t('Automatically expand permission providers when search results match their permissions.'),
      '#default_value' => $config->get('auto_expand_search') ?? TRUE,
    ];

    $form['cache_lifetime'] = [
      '#type' => 'number',
      '#title' => $this->t('Cache lifetime'),
      '#description' => $this->t('Duration in seconds to cache permission data. Set to 0 to disable caching. Maximum: 86400 seconds (24 hours).'),
      '#default_value' => $config->get('cache_lifetime') ?? 3600,
      '#min' => 0,
      '#max' => 86400,
      '#step' => 1,
      '#field_suffix' => $this->t('seconds'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('permission_turbo.settings')
      ->set('replace_core', (bool) $form_state->getValue('replace_core'))
      ->set('auto_expand_search', (bool) $form_state->getValue('auto_expand_search'))
      ->set('cache_lifetime', (int) $form_state->getValue('cache_lifetime'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
