/**
 * @file
 * User notifications settings page.
 */

(async (Drupal, drupalSettings) => {
  'use strict';

  const registration = await navigator.serviceWorker.getRegistration();

  const permission = await Notification.requestPermission();
  if (permission !== 'denied') {
    document.getElementById('has-browser-permission-send-notifications').innerHTML = 'TRUE';
  }

  /**
   * Send notification to device.
   *
   * TODO: send notification using the registered subscription data in Drupal and the service worker in this module.
   *
   * @returns {Promise<void>}
   */
  const sendNotification = async () => {
    if (permission === 'denied') {
      const permission = await Notification.requestPermission();
      if(permission === 'granted') {
        document.getElementById('has-browser-permission-send-notifications').innerHTML = 'TRUE';
        showNotification();
      }
    } else {
      showNotification();
    }
  }

  const showNotification = () => {
    const title = '1..2...3, test title!'
    const payload = {
      body: '1 2 3, body text here'
    };
    if('showNotification' in registration) {
      registration.showNotification(title, payload);
    }
    else {
      new Notification(title, payload);
    }
  }

  document.getElementById('test-notification').addEventListener('click', sendNotification);

})(Drupal, drupalSettings);
