# Drupal Commerce PhonePe Payment Gateway

This module provides integration between Drupal Commerce and PhonePe Payment Gateway.

## Structure

This module follows Drupal best practices by separating the PhonePe SDK library from the Drupal-specific module code:

- **`src/`** - Drupal module-specific code (plugins, forms, controllers)
- The PhonePe SDK library (`rishabjasrotia/phonepe-drupal-sdk`) is installed via Composer as a dependency

## Installation

1. Install the module using Composer:
   ```bash
   composer require drupal/phonepay_payment
   ```

2. The PhonePe SDK library (`rishabjasrotia/phonepe-drupal-sdk`) will be automatically installed as a dependency from [Packagist](https://packagist.org/packages/rishabjasrotia/phonepe-drupal-sdk).

## Configuration

1. Navigate to `/admin/commerce/config/payment-gateways`
2. Add a new payment gateway and select "PhonePe Payment"
3. Configure your PhonePe merchant credentials:
   - Merchant ID
   - Merchant User ID
   - Salt Key
   - Salt Index
   - API Key (optional)
   - Merchant Website (optional)

## Requirements

- Drupal 9.x, 10.x, or 11.x
- Drupal Commerce 2.x
- PHP >= 7.4
- Guzzle HTTP Client (automatically installed via SDK)

## SDK Package

The PhonePe SDK is available as a standalone package on Packagist:
- **Package**: [rishabjasrotia/phonepe-drupal-sdk](https://packagist.org/packages/rishabjasrotia/phonepe-drupal-sdk)
- **GitHub**: [github.com/rishabjasrotia/phonepe-drupal-sdk](https://github.com/rishabjasrotia/phonepe-drupal-sdk)

You can use the SDK independently in other PHP projects:
```bash
composer require rishabjasrotia/phonepe-drupal-sdk
```

## License

GPL-2.0+

