/**
 * @file
 * Sortable to rearrange photos by weight in album.
 */

(($, Drupal, drupalSettings, Sortable) => {
  Drupal.behaviors.photosDragNDrop = {
    attach() {
      const photosSortable = document.getElementById('photos-sortable');
      if (photosSortable) {
        Sortable.create(photosSortable, {
          store: {
            set(sortable) {
              // Save new order.
              const sortedIDs = JSON.stringify(sortable.toArray());
              const sortUrl = Drupal.url('photos/ajax/rearrange');
              const postData = {
                order: sortedIDs,
                album_id: drupalSettings.photos.album_id,
                uid: drupalSettings.photos.uid,
                type: drupalSettings.photos.sort,
              };
              const $photosSortUpdatesSelector = $('#photos-sort-updates');
              $.ajax({
                type: 'POST',
                url: sortUrl,
                data: postData,
                success(message) {
                  document.getElementById('photos-sort-updates').textContent =
                    message;
                  $photosSortUpdatesSelector.show();
                  $photosSortUpdatesSelector.delay(500).fadeOut(500);
                },
              });
            },
          },
        });
      }
    },
  };
})(jQuery, Drupal, drupalSettings, Sortable);
