/**
 * @file
 * Photos statistics functionality.
 */

(function _($, drupalSettings) {
  setTimeout(() => {
    $.ajax({
      type: 'POST',
      cache: false,
      async: true,
      dataType: 'json',
      url: drupalSettings.photosStatistics.url,
      data: drupalSettings.photosStatistics.data,
      complete(data) {
        document.getElementById(
          `photos-visits-${drupalSettings.photosStatistics.data.id}`,
        ).textContent = Drupal.formatPlural(
          parseInt(data.responseJSON.count, 10),
          '1 visit',
          '@count visits',
        );
        $(
          `#photos-visits-${drupalSettings.photosStatistics.data.id}`,
        ).removeClass('hidden');
      },
    });
  });
})(jQuery, drupalSettings);
