<?php

declare(strict_types=1);

namespace Drupal\php_password;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceModifierInterface;

/**
 * Defines a service provider for php_password.
 */
final class PhpPasswordServiceProvider implements ServiceModifierInterface {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $definition = $container->getDefinition('password');
    if (\count($definition->getArguments()) === 0 && $container->hasParameter('password.algorithm')) {
      // In Drupal 10.4, 10.5, 11.1 and 11.2 there are no arguments to this
      // service. From 11.3 and 10.6, the password algorithm and options can be
      // configured via service parameters.
      $definition->setArguments([
        $container->getParameter('password.algorithm'),
        $container->hasParameter('password.options') ? $container->getParameter('password.options') : [] ,
      ]);
    }
  }

}
