
## CONTENTS OF THIS FILE


 * Introduction
 * Installation
 * Configuration


## INTRODUCTION


Current Maintainer: James Gilliland <neclimdul@gmail.com>

A forward compatibility layer for [configurable password hashing algorithms in core](https://drupal.org/i/3530186)

## INSTALLATION


The php_password module will take care of replacing Drupal's password manager
for you so installation is as simple as installing any other Drupal module.

## CONFIGURATION

Configuration is via container parameters. If you have an existing `services.yml` file in your sites folder (e.g. `sites/default/files/services.yml`),
you can simply add two new parameters.

```
parameters:
  # Can be argon2i, argon2id or 2y
  password.algorithm: argon2id # 👈️ Parameter 1
  # See https://www.php.net/password_hash
  password.options: [] # 👈️ Parameter 2

```

If you don't have an existing services.yml file, you can create one and load it by adding this your settings.php

```php
// Add to your settings.php - use the path of the file you created.
$settings['container_yamls'][] = DRUPAL_ROOT . '/sites/default/services.yml';

```
