<?php

namespace Drupal\pianoanalytics\Plugin\Block;

use Drupal\Component\Utility\Html;
use Drupal\Core\Block\BlockBase;

/**
 * Provides an opt-out switch for Piano Analytics tracking.
 *
 * @Block(
 *   id = "pianoanalytics_optout_block",
 *   admin_label = @Translation("Piano Analytics Opt-Out Switch")
 * )
 */
class PianoAnalyticsOptoutBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    // Generate a unique ID for the checkbox input.
    $checkbox_id = Html::getUniqueId('pianoanalytics-optout-switch');

    return [
      '#type' => 'inline_template',
      '#template' => '
      <div class="pianoanalytics-optout-switch-container">
        <label for="{{ checkbox_id }}">
          <span class="visually-hidden">{{ hidden_label }}</span>
          <input
            type="checkbox"
            class="pianoanalytics-optout-switch"
            id="{{ checkbox_id }}"
            aria-describedby="{{ checkbox_id }}-description"
            aria-label="{{ aria_label }}" />
        </label>

        {# Text shown next to the switch; it is visually informative. #}
        <span id="{{ checkbox_id }}-description" class="pianoanalytics-switch-label">{{ optout_label }}</span>
      </div>
    ',
      '#context' => [
        // Unique ID for the checkbox input.
        'checkbox_id' => $checkbox_id,

        // Visible label for sighted users.
        'optout_label' => $this->t('Opt-out of Piano Analytics'),

        // Hidden label for screen readers.
        'hidden_label' => $this->t('Toggle Piano Analytics tracking'),

        // Aria-label to describe the purpose of the switch to screen readers.
        'aria_label' => $this->t('Opt-out of analytics tracking'),
      ],
      '#attached' => [
        'library' => [
          'pianoanalytics/pianoanalytics_optout_switch',
        ],
      ],
    ];
  }

}
