/**
 * Piano Analytics Opt-out Toggle
 *
 * Syncs opt-out checkboxes with localStorage and updates all instances on user change.
 */
((Drupal, once) => {
  Drupal.behaviors.pianoanalyticsOptOutSwitch = {
    attach(context) {
      const selector = '.pianoanalytics-optout-switch';

      // Initialize all matching checkboxes once per context
      once('pianoanalyticsOptOutSwitch', selector, context).forEach((el) => {
        // Set initial state from localStorage
        el.checked = localStorage.getItem('pianoanalytics_optout') === 'true';

        // Add change listener to this checkbox
        el.addEventListener('change', () => {
          const newValue = el.checked;
          localStorage.setItem('pianoanalytics_optout', newValue.toString());

          // Synchronize all checkboxes with this class
          document.querySelectorAll(selector).forEach((checkbox) => {
            checkbox.checked = newValue;
          });
        });
      });
    },
  };
})(Drupal, once);
