<?php

namespace Drupal\pianoanalytics\Plugin\Block;

use Drupal\Component\Utility\Html;
use Drupal\Core\Block\BlockBase;

/**
 * Provides an opt-out switch for Piano Analytics tracking.
 *
 * @Block(
 *   id = "pianoanalytics_optout_block",
 *   admin_label = @Translation("Piano Analytics Opt-Out Switch")
 * )
 */
class PianoAnalyticsOptoutBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    // Generate a unique ID for the checkbox input.
    $checkbox_id = Html::getUniqueId('pianoanalytics-optout-switch');

    return [
      '#type' => 'inline_template',
      '#template' => '
      <div class="pianoanalytics-optout-switch-container">
        <label for="{{ checkbox_id }}">
          <input
            type="checkbox"
            class="pianoanalytics-optout-switch"
            id="{{ checkbox_id }}"
            role="switch" />
          <span class="pianoanalytics-switch-label">{{ optout_label }}</span>
        </label>
      </div>
    ',
      '#context' => [
        // Unique ID for the checkbox input.
        'checkbox_id' => $checkbox_id,
        'optout_label' => $this->t('Opt-out of Piano Analytics tracking'),
      ],
      '#attached' => [
        'library' => [
          'pianoanalytics/pianoanalytics_optout_switch',
        ],
      ],
    ];
  }

}
