# Pie Chart

The Pie Chart provides the structure for a pie chart content type
based on node count. Additionally, it includes the structure for user
roles with different user counts per role. This module also provides blocks
for content pie charts and custom pie charts that can be placed anywhere
within regions. Most importantly, the chart supports responsive design.

## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers

## REQUIREMENTS

An internet connection is required for this module because it uses Google
Charts, which depend on internet access. When the internet is not available,
this module will be hidden.

## INSTALLATION

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## CONFIGURATION
- Content Pie Chart URL: /admin/content/pie-chart
- User Pie Chart URL: /admin/people/pie-chart
- To place the blocks, go to any region and search for:
  - "Node Pie Chart Block" - Shows pie chart based on content type counts
  - "Custom Pie Chart Block" - Configurable pie chart with Name/Value pairs

### Custom Pie Chart Block Usage
The Custom Pie Chart Block allows you to create pie charts with custom data:

1. Place the "Custom Pie Chart Block" in any region
2. Configure the block by entering Name/Value pairs in the textarea
3. Format: One pair per line as `Name|Value`
   - Example:
     ```
     January|25
     February|30
     March|20
     April|35
     ```
4. Save the block configuration
5. The pie chart will render automatically on the page

**Note**: Values must be numeric. Invalid lines are automatically skipped.

## MAINTAINERS

Current maintainers for Drupal 10:

- Vishal Kumar (vishalydv) - https://www.drupal.org/u/vishal-yadav
