(function ($, Drupal) {
  Drupal.behaviors.mychart = {
    attach: function (context, settings) {
      // Ensure that Google Charts API is loaded
      google.charts.load('current', {
        'packages': ['corechart']
      });
      /* for user pie chart */
      if (drupalSettings.userCounts) {
        var counts = drupalSettings.userCounts;

        function convertToArray(obj) {
          let result = [
            ["Role", "Ucount"]
          ];
          for (let key in obj) {
            if (obj.hasOwnProperty(key)) {
              result.push([key, (obj[key])]);
            }
          }
          return result;
        }
        var UserArray = convertToArray(counts);
        google.charts.setOnLoadCallback(drawChart);

        function drawChart() {
          var data = google.visualization.arrayToDataTable(UserArray);
          var options = {
            title: 'User Pie Chart',
            width: 600,
            height: 500,
            chartArea: {
              left: "10%",
              top: "10%",
              width: "80%",
              height: "80%"
            },
            titleTextStyle: {
              fontSize: 20,
              bold: true
            },
            legend: {
              position: 'right',
              textStyle: {
                fontSize: 16,
                bold: true,
                color: '#333'
              }
            },
          };
          var chart = new google.visualization.PieChart(document.getElementById('piechart'));
          chart.draw(data, options);
        }
      }

      /* for block node pie chart */
      if (drupalSettings.fromblock) {
        var nodeCounts = drupalSettings.fromblock;

        function convertToArray(obj) {
          let result = [
            ["type", "ncount"]
          ];
          for (let key in obj) {
            if (obj.hasOwnProperty(key)) {
              result.push([key, parseInt(obj[key], 10)]);
            }
          }
          return result;
        }
        var nodeArray = convertToArray(nodeCounts);
        google.charts.setOnLoadCallback(drawChart);

        function drawChart() {
          var data = google.visualization.arrayToDataTable(nodeArray);
          var options = {
            title: 'Content Pie Chart',
            width: 600,
            height: 500,
            chartArea: {
              left: "10%",
              top: "10%",
              width: "80%",
              height: "80%"
            },
            titleTextStyle: {
              fontSize: 20,
              bold: true
            },
            legend: {
              position: 'right',
              textStyle: {
                fontSize: 16,
                bold: true,
                color: '#333'
              }
            },
          };
          var chart = new google.visualization.PieChart(document.getElementById('piechart'));
          chart.draw(data, options);
        }
      }

      /* for custom pie chart block with Name/Value pairs */
      if (drupalSettings.customblock) {
        var customCounts = drupalSettings.customblock;

        function convertCustomToArray(obj) {
          let result = [
            ["Name", "Value"]
          ];
          for (let key in obj) {
            if (obj.hasOwnProperty(key)) {
              result.push([key, parseInt(obj[key], 10)]);
            }
          }
          return result;
        }

        var customArray = convertCustomToArray(customCounts);
        google.charts.setOnLoadCallback(drawCustomChart);

        function drawCustomChart() {
          var data = google.visualization.arrayToDataTable(customArray);
          var options = {
            title: '',
            chartArea: {
              left: 50,
              top: 50,
              right: 50,
              bottom: 50
            },
            titleTextStyle: {
              fontSize: 20,
              bold: true
            },
            legend: {
              alignment: 'center',
              textStyle: {
                fontSize: 16,
                bold: true,
                color: '#333'
              }
            },
          };
          var chart = new google.visualization.PieChart(document.getElementById('piechart'));
          chart.draw(data, options);
        }
      }

      /* for content pie chart */
      if (settings.pie_chart && settings.pie_chart.node_counts) {
        var nodeCounts = settings.pie_chart.node_counts;

        function convertToArray(obj) {
          let result = [
            ["type", "ncount"]
          ];
          for (let key in obj) {
            if (obj.hasOwnProperty(key)) {
              result.push([key, parseInt(obj[key], 10)]);
            }
          }
          return result;
        }

        var nodeArray = convertToArray(nodeCounts);
        google.charts.setOnLoadCallback(drawChart);

        function drawChart() {
          var data = google.visualization.arrayToDataTable(nodeArray);
          var options = {
            title: 'Content Pie Chart',
            width: 600,
            height: 500,
            chartArea: {
              left: "10%",
              top: "10%",
              width: "80%",
              height: "80%"
            },
            titleTextStyle: {
              fontSize: 20,
              bold: true
            },
            legend: {
              position: 'right',
              textStyle: {
                fontSize: 16,
                bold: true,
                color: '#333'
              }
            },
          };
          var chart = new google.visualization.PieChart(document.getElementById('piechart'));
          chart.draw(data, options);
        }
      }
    }
  };
})(jQuery, Drupal);