(function ($, Drupal) {
    Drupal.behaviors.mychart = {
      attach: function (context, settings) {
        // Ensure that Google Charts API is loaded
        google.charts.load('current', {
          'packages': ['corechart']
        });
        /* for user pie chart */
        if (drupalSettings.userCounts) {
          var counts = drupalSettings.userCounts;

          function convertUserToArray(obj) {
            let result = [
              ["Role", "Ucount"]
            ];
            for (let key in obj) {
              if (obj.hasOwnProperty(key)) {
                result.push([key, (obj[key])]);
              }
            }
            return result;
          }
          var UserArray = convertUserToArray(counts);
          google.charts.setOnLoadCallback(drawUserChart);

          function drawUserChart() {
            var data = google.visualization.arrayToDataTable(UserArray);
            var options = {
              title: 'User Pie Chart',
              chartArea: {
                left: 50,
                /* Adjust margin on the left side */
                top: 50,
                /* Adjust margin on the top */
                right: 50,
                /* Adjust margin on the right side */
                bottom: 50 /* Adjust margin on the bottom */
              },
              titleTextStyle: {
                fontSize: 20,
                bold: true
              },
              legend: {
                alignment: 'left',
                textStyle: {
                  fontSize: 20,
                  /*Font size for the legend text*/
                  bold: true,
                  /*Make the legend text bold*/
                  color: '#333' /*Color of the legend text*/
                }
              },
            };
            var chart = new google.visualization.PieChart(document.getElementById('piechart'));
            chart.draw(data, options);
          }
        }

        /* for block node pie chart */
        if (drupalSettings.fromblock) {
          var nodeCounts = drupalSettings.fromblock;

          function convertNodeToArray(obj) {
            let result = [
              ["type", "ncount"]
            ];
            for (let key in obj) {
              if (obj.hasOwnProperty(key)) {
                result.push([key, parseInt(obj[key], 10)]);
              }
            }
            return result;
          }
          var nodeArray = convertNodeToArray(nodeCounts);
          google.charts.setOnLoadCallback(drawNodeChart);

          function drawNodeChart() {
            var data = google.visualization.arrayToDataTable(nodeArray);
            var options = {
              title: '',
              chartArea: {
                left: 50,
                /* Adjust margin on the left side */
                top: 50,
                /* Adjust margin on the top */
                right: 50,
                /* Adjust margin on the right side */
                bottom: 50 /* Adjust margin on the bottom */
              },
              titleTextStyle: {
                fontSize: 20,
                bold: true
              },
              legend: {
                alignment: 'center',
                textStyle: {
                  fontSize: 16,
                  /*Font size for the legend text*/
                  bold: true,
                  /*Make the legend text bold*/
                  color: '#333' /*Color of the legend text*/
                }
              },
            };
            var chart = new google.visualization.PieChart(document.getElementById('piechart'));
            chart.draw(data, options);
          }
        }

        /* for custom pie chart block with Name/Value pairs */
        if (drupalSettings.customblock) {
          var customCounts = drupalSettings.customblock;

          function convertCustomToArray(obj) {
            let result = [
              ["Name", "Value"]
            ];
            for (let key in obj) {
              if (obj.hasOwnProperty(key)) {
                result.push([key, parseInt(obj[key], 10)]);
              }
            }
            return result;
          }

          var customArray = convertCustomToArray(customCounts);
          google.charts.setOnLoadCallback(drawCustomChart);

          function drawCustomChart() {
            var data = google.visualization.arrayToDataTable(customArray);
            var options = {
              title: '',
              chartArea: {
                left: 50,
                top: 50,
                right: 50,
                bottom: 50
              },
              titleTextStyle: {
                fontSize: 20,
                bold: true
              },
              legend: {
                alignment: 'center',
                textStyle: {
                  fontSize: 16,
                  bold: true,
                  color: '#333'
                }
              },
            };
            var chart = new google.visualization.PieChart(document.getElementById('custompiechart'));
            chart.draw(data, options);
          }
        }

        /* for content pie chart */
        if (settings.pie_chart && settings.pie_chart.node_counts) {
          var nodeCounts = settings.pie_chart.node_counts;

          function convertContentToArray(obj) {
            let result = [
              ["type", "ncount"]
            ];
            for (let key in obj) {
              if (obj.hasOwnProperty(key)) {
                result.push([key, parseInt(obj[key], 10)]);
              }
            }
            return result;
          }

          var nodeArray = convertContentToArray(nodeCounts);
          google.charts.setOnLoadCallback(drawContentChart);

          function drawContentChart() {
            var data = google.visualization.arrayToDataTable(nodeArray);
            var options = {
              title: 'Content Pie Chart',
              chartArea: {
                left: 50,
                /* Adjust margin on the left side */
                top: 50,
                /* Adjust margin on the top */
                right: 50,
                /* Adjust margin on the right side */
                bottom: 50 /* Adjust margin on the bottom */
              },
              titleTextStyle: {
                fontSize: 25,
                bold: true
              },
              legend: {
                alignment: 'left',
                textStyle: {
                  fontSize: 20,
                  /*Font size for the legend text*/
                  bold: true,
                  /*Make the legend text bold*/
                  color: '#333' /*Color of the legend text*/
                }
              },
            };
            var chart = new google.visualization.PieChart(document.getElementById('piechart'));
            chart.draw(data, options);
          }
        }
      }
    };
  })(jQuery, Drupal);