# PillarShield — Publishing Governance for Drupal

**PillarShield** is a publishing governance service that helps evaluate content before it is saved or published.

This Drupal module connects your site to the PillarShield SaaS API and applies governance checks during content entry and publishing workflows.

Learn more:
👉 [pillarshield.co](https://pillarshield.co)

---

## What this module does

When enabled and configured, this module can:

- Send node content to the PillarShield service for governance evaluation
- Receive allow / warn / block decisions
- Prevent saves or publishing when content is blocked (depending on configuration)
- Optionally allow authorized users to override warnings or blocks (if enabled)

This module is intended to complement editorial workflows by adding a governance check during content updates.

---

## Requirements

- Drupal 10 or 11
- Key module (`drupal/key`)

---

## Setup

1. Enable the module.
2. Configure your PillarShield API key (recommended via the Key module)
3. Configure your entity type and field settings (`/admin/config/content/pillarshield`).
4. Configure governance rules and enforcement behavior under the PillarShield settings page.

You will need an active PillarShield tenant/API key to use the service.
Get started at:
👉 [pillarshield.co](https://pillarshield.co)

---

## Project status

This module is in **early development** and may change as the PillarShield platform evolves.
It is already usable, but treat it as actively evolving.

---

## About PillarShield / Maintainer

PillarShield is a product of **[PillarPoint Consulting LLC](https://pillarpoint.consulting)**.

This module is released and maintained by:
**Patrick Teglia**
https://www.drupal.org/u/crashtest_
