<?php

declare(strict_types=1);

namespace Drupal\pinto\List;

use Drupal\pinto\Controller\PintoAssetController;

/**
 * @phpstan-require-implements \Drupal\pinto\List\StreamWrapperAssetInterface
 */
trait StreamWrapperAssetTrait {

  /**
   * @see \Drupal\pinto\StreamWrapper\PintoComponentStreamWrapper::getDirectoryPath()
   */
  final public function cssDirectory(): string {
    return \sprintf('pinto-component://css/%s/%s', PintoAssetController::hashEnum(static::class), $this->name);
  }

  /**
   * @see \Drupal\pinto\StreamWrapper\PintoComponentStreamWrapper::getDirectoryPath()
   */
  final public function jsDirectory(): string {
    return \sprintf('pinto-component://js/%s/%s', PintoAssetController::hashEnum(static::class), $this->name);
  }

  abstract public function absoluteCssDirectory(): string;

  abstract public function absoluteJsDirectory(): string;

}
