<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Asset;

use Pinto\Attribute\Definition;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;
use function Safe\realpath;

#[Slots(slots: ['text'])]
enum DependencyOnAssetParent implements ObjectListInterface {

  use ObjectListTrait;

  #[Definition(DependencyOnAssetParentObject::class)]
  case Parent;

  public function templateDirectory(): string {
    return '@pinto_test/templates/asset/';
  }

  public function cssDirectory(): string {
    return realpath(__DIR__ . '/../../../css');
  }

  public function jsDirectory(): string {
    return realpath(__DIR__ . '/../../../js');
  }

}
