<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Asset;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\Asset\Css;
use Pinto\Slots\Build;

#[Css('parent-styles.css')]
class DependencyOnAssetParentObject {

  use DrupalObjectTrait;

  public function __invoke(): mixed {
    return $this->pintoBuild(static function (Build $build): Build {
      return $build
        ->set('text', 'Text from DependencyOnAssetParentObject!');
    });
  }

}
