<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Nested;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\Slots\Build;

/**
 * Test object.
 */
#[Slots(slots: ['foo'])]
final class ObjectNestedInner {

  use DrupalObjectTrait;

  /**
   * Constructor.
   */
  public function __construct(
    readonly string $text,
  ) {
  }

  /**
   * Creates a new object.
   */
  public static function create(
    string $text,
  ): static {
    return new static($text);
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build->set('foo', $this->text);
    });
  }

}
