<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Slots;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\Slots\Build;

/**
 * Tests slots type.
 */
#[Slots]
class SlotsObjectInheritance {

  use DrupalObjectTrait;

  /**
   * Constructor.
   */
  public function __construct(
    readonly string $slotOnRoot,
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('slotOnRoot', $this->slotOnRoot);
    });
  }

}
