<?php

declare(strict_types=1);

namespace Drupal\pinto\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\pinto\List\StreamWrapperAssetInterface;
use Pinto\Attribute\Asset\Css;
use Pinto\Attribute\Asset\Js;
use Pinto\PintoMapping;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

final class PintoAssetController extends ControllerBase {

  public function __construct(
    private PintoMapping $pintoMapping,
  ) {}

  public function js(string $enumHash, string $enumCase, string $filePath): Response {
    foreach ($this->pintoMapping->getEnumClasses() as $enumClass) {
      if (PintoAssetController::hashEnum($enumClass) === $enumHash) {
        $enumStr = \sprintf('%s::%s', $enumClass, $enumCase);
        if (FALSE === \defined($enumStr)) {
          throw new NotFoundHttpException();
        }

        /** @var \Pinto\List\ObjectListInterface $enum */
        $enum = \constant($enumStr);
        if (!$enum instanceof StreamWrapperAssetInterface) {
          throw new \LogicException(\sprintf('Enum does not implement %s', StreamWrapperAssetInterface::class));
        }

        $dir = $enum->absoluteJsDirectory();
        foreach ($enum->assets() as $asset) {
          // @todo Change to JsAssetInterface.
          if ($asset instanceof Js) {
            if ($asset->path === $filePath) {
              $path = \sprintf('%s/%s', $dir, $filePath);
              if (\file_exists($path)) {
                return new BinaryFileResponse($path);
              }
            }
          }
        }
      }
    }

    throw new NotFoundHttpException();
  }

  public function css(string $enumHash, string $enumCase, string $filePath): Response {
    foreach ($this->pintoMapping->getEnumClasses() as $enumClass) {
      if (PintoAssetController::hashEnum($enumClass) === $enumHash) {
        $enumStr = \sprintf('%s::%s', $enumClass, $enumCase);
        if (FALSE === \defined($enumStr)) {
          throw new NotFoundHttpException();
        }

        /** @var \Pinto\List\ObjectListInterface $enum */
        $enum = \constant($enumStr);
        if (!$enum instanceof StreamWrapperAssetInterface) {
          throw new \LogicException(\sprintf('Enum does not implement %s', StreamWrapperAssetInterface::class));
        }

        $dir = $enum->absoluteCssDirectory();
        foreach ($enum->assets() as $asset) {
          // @todo Change to CssAssetInterface.
          if ($asset instanceof Css) {
            if ($asset->path === $filePath) {
              $path = \sprintf('%s/%s', $dir, $filePath);
              if (\file_exists($path)) {
                return new BinaryFileResponse($path);
              }
            }
          }
        }
      }
    }

    throw new NotFoundHttpException();
  }

  /**
   * @phpstan-param class-string<\Pinto\List\ObjectListInterface> $enumClass
   * @internal
   */
  public static function hashEnum(string $enumClass): string {
    return \md5($enumClass);
  }

}
