<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Asset;

use Pinto\Attribute\Definition;
use Pinto\Attribute\DependencyOn;
use Pinto\CanonicalProduct\Attribute\CanonicalProduct;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;
use function Safe\realpath;

#[DependencyOn(parent: TRUE)]
#[CanonicalProduct]
enum DependencyOnAssetChild implements ObjectListInterface {

  use ObjectListTrait;

  #[Definition(DependencyOnAssetChildObject::class)]
  case Child;

  public function templateDirectory(): string {
    return '@pinto_test/templates/asset/';
  }

  public function cssDirectory(): string {
    return realpath(__DIR__ . '/../../../css');
  }

  public function jsDirectory(): string {
    return realpath(__DIR__ . '/../../../js');
  }

}
