<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\CanonicalProduct;

use Pinto\Attribute\Definition;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;
use function Safe\realpath;

/**
 * Defines objects to test canonical product factory.
 */
enum CanonicalProductExtendingList implements ObjectListInterface {

  use ObjectListTrait;

  #[Definition(CanonicalProductExtending::class)]
  case CanonicalProductExtending;

  public function templateName(): string {
    // Replace capital letters with hyphen + lowercase version of letter.
    // Then remove leading hyphen.
    // e.g: 'FooBar' -> 'foo-bar'.
    return \trim(\strtolower(\preg_replace('/([A-Z])/', '-$1', $this->name()) ?? ''), '-');
  }

  public function templateDirectory(): string {
    return '@pinto_test/templates/canonical-product/';
  }

  public function cssDirectory(): string {
    return realpath(__DIR__ . '/../../../css');
  }

  public function jsDirectory(): string {
    return realpath(__DIR__ . '/../../../js');
  }

}
