<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Traits;

use Drupal\pinto\Object\DrupalInvokableSlotsTrait;
use Pinto\Attribute\ObjectType;
use Pinto\Slots;

#[ObjectType\Slots]
final class DrupalInvokableSlotsTraitObject {

  use DrupalInvokableSlotsTrait;

  public function __construct(
    private readonly string $text,
  ) {
  }

  protected function build(Slots\Build $build): Slots\Build {
    return $build
      ->set('text', $this->text);
  }

}
