<?php

declare(strict_types=1);

namespace Drupal\Tests\pinto\Kernel;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\KernelTests\KernelTestBase;
use Drupal\pinto_test\NonDiscovery\NonDiscovery;
use Pinto\PintoMapping;

/**
 * Tests Pinto objects outside of discovery.
 *
 * Which are added to PintoMapping via `pinto.lists` parameter.
 *
 * @group pinto
 */
final class PintoNonDiscoveryTest extends KernelTestBase {

  protected static $modules = [
    'pinto_test',
    'pinto',
  ];

  /**
   * Test objects in definitions.
   *
   * @see \Drupal\pinto_test\Pinto\Generic\ObjectThemeDefinitionClass
   */
  public function testNonDiscovery(): void {
    static::assertContains(NonDiscovery::class, static::pintoMapping()->getEnumClasses());
  }

  public function register(ContainerBuilder $container): void {
    parent::register($container);

    $container->setParameter('pinto.lists', [
      NonDiscovery::class,
    ]);
  }

  private static function pintoMapping(): PintoMapping {
    /** @var \Pinto\PintoMapping */
    return \Drupal::service(PintoMapping::class);
  }

}
