<?php

declare(strict_types=1);

namespace Drupal\Tests\pinto\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\pinto_test\Pinto\Traits\DrupalInvokableSlotsTraitObject;

/**
 * Tests the DX traits.
 *
 * @group pinto
 */
final class PintoTraitsTest extends KernelTestBase {

  protected static $modules = [
    'pinto_test',
    'pinto',
  ];

  /**
   * @see \Drupal\pinto\Object\DrupalObjectTrait
   */
  public function testDrupalObjectTrait(): void {
    $text = $this->randomMachineName();
    $obj = new DrupalInvokableSlotsTraitObject($text);
    $built = $obj();
    static::assertEquals($text, $built['#text']);
  }

  /**
   * @see \Drupal\pinto\Object\DrupalInvokableSlotsTrait
   */
  public function testDrupalInvokableSlotsTrait(): void {
    $text = $this->randomMachineName();
    $obj = new DrupalInvokableSlotsTraitObject($text);
    $built = $obj();
    static::assertEquals($text, $built['#text']);
  }

}
