<?php

declare(strict_types=1);

namespace Drupal\pinto\List;

/**
 * An implementation where all resources are in a single directory.
 *
 * @see \Pinto\Resource\ResourceInterface
 * @phpstan-require-implements \Pinto\Resource\ResourceInterface
 */
trait SingleDirectoryObjectListTrait {

  public function templateName(): string {
    return 'template';
  }

  public function templateDirectory(): string {
    return $this->twigDirectory();
  }

  public function cssDirectory(): string {
    return $this->libraryDirectory();
  }

  public function jsDirectory(): string {
    return $this->libraryDirectory();
  }

  /**
   * May be extended.
   */
  protected function twigDirectory(): string {
    // Gets the resources from the same directory as the object PHP file.
    // Override this method with a different directory if you want to keep
    // assets in different directories from object PHP files.
    return SingleDirectoryObjectListCache::twigNsAndDir($this->getClass() ?? throw new \LogicException('All resources associated using SingleDirectoryObjectListTrait must have an associated className.'));
  }

  /**
   * May be extended.
   */
  protected function libraryDirectory(): string {
    // Gets the resources from the same directory as the object PHP file.
    // Override this method with a different directory if you want to keep
    // assets in different directories from object PHP files.
    return SingleDirectoryObjectListCache::libraryDir($this->getClass() ?? throw new \LogicException('All resources associated using SingleDirectoryObjectListTrait must have an associated className.'));
  }

}
