<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\CanonicalProduct;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\CanonicalProduct\Attribute\CanonicalProduct;
use Pinto\Slots\Build;

/**
 * Tests canonical product.
 */
#[CanonicalProduct]
final class CanonicalProductExtending extends CanonicalProductRoot {

  use DrupalObjectTrait;

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('canonical_product_slot', 'Value from Child! ' . $this->text);
    });
  }

}
