<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\DependencyOn;

use Pinto\Attribute\Definition;
use Pinto\Attribute\DependencyOn;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;

use function Safe\realpath;

#[DependencyOn(parent: TRUE)]
enum PintoListDependenciesHierarchyChild implements ObjectListInterface {
  use ObjectListTrait;

  #[Definition(PintoObjectDependencyOnChild::class)]
  case Child;

  public function libraryName(): string {
    return 'PintoListDependenciesHierarchyChild-' . $this->name();
  }

  public function name(): string {
    return \sprintf('dependency-on-%s', $this->name);
  }

  public function templateDirectory(): string {
    return '@pinto_test/dependency-on/';
  }

  public function cssDirectory(): string {
    return realpath(__DIR__ . '/../../resources/css');
  }

  public function jsDirectory(): string {
    return realpath(__DIR__ . '/../../resources/javascript');
  }

}
