<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\DependencyOn;

use Pinto\Attribute\Definition;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;

use function Safe\realpath;

enum PintoListDependenciesHierarchyParent implements ObjectListInterface {
  use ObjectListTrait;

  #[Definition(PintoObjectDependencyOnParent::class)]
  case Parent;

  public function name(): string {
    return \sprintf('dependency-on-%s', $this->name);
  }

  public function libraryName(): string {
    return 'PintoListDependenciesHierarchyParent-' . $this->name();
  }

  public function templateDirectory(): string {
    return '@pinto_test/dependency-on/';
  }

  public function cssDirectory(): string {
    return realpath(__DIR__ . '/../../../css');
  }

  public function jsDirectory(): string {
    return realpath(__DIR__ . '/../../../js');
  }

}
