<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Nested;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\Slots\Build;

/**
 * Test object.
 */
#[Slots(slots: ['inner'])]
final class ObjectNestedViaVariable {

  use DrupalObjectTrait;

  /**
   * Constructor.
   *
   * @phpstan-param callable-object $object
   */
  public function __construct(
    readonly object $object,
  ) {
  }

  /**
   * Creates a new object.
   *
   * @phpstan-param callable-object $object
   */
  public static function create(
    object $object,
  ): static {
    return new static($object);
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build->set('inner', $this->object);
    });
  }

}
