<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Slots;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Slots;
use Pinto\Slots\Attribute\ModifySlots;
use Pinto\Slots\Build;

/**
 * Tests slots type with added slots.
 */
#[ModifySlots(
  add: [
    new Slots\Slot('addedSlotsOnChild'),
  ],
)]
final class SlotsObjectInheritanceModifySlotsAddSlots extends SlotsObjectInheritanceRenameSlot {

  use DrupalObjectTrait;

  public function __invoke(): mixed {
    return $this->pintoBuild(static function (Build $build): Build {
      return $build
        ->set('slotOnRoot', 'value for root')
        ->set('addedSlotsOnChild', 'value for added slot');
    });
  }

}
