<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Standalone\StandaloneGlob;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\Asset\Css;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\Slots\Build;

/**
 * A component not in a list.
 *
 * Added to discovery since it has a ObjectTypeInterface attribute, and is not referenced by a list.
 *
 * When an asset is present, glob is disabled for both JS and CSS.
 *
 * So, #[Js] is omitted intentionally.
 */
#[Slots]
#[Css]
final class StandaloneGlob {

  use DrupalObjectTrait;

  public function __construct(
    readonly string $text,
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('text', $this->text);
    });
  }

}
