<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Traits;

use Pinto\Attribute\Definition;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;

enum TraitsList implements ObjectListInterface {

  use ObjectListTrait;

  #[Definition(DrupalObjectTraitObject::class)]
  case DrupalObjectTraitObject;

  #[Definition(DrupalInvokableSlotsTraitObject::class)]
  case DrupalInvokableSlotsTraitObject;

  public function templateDirectory(): string {
    return '@pinto_test/templates/traits/';
  }

  public function cssDirectory(): string {
    throw new \LogicException('Not covered.');
  }

  public function jsDirectory(): string {
    throw new \LogicException('Not covered.');
  }

}
