<?php

declare(strict_types=1);

namespace Drupal\Tests\pinto\Kernel;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\KernelTests\KernelTestBase;
use Drupal\pinto_test\NonDiscovery\NonDiscovery;
use Pinto\List\Resource\ObjectListEnumResource;
use Pinto\PintoMapping;

/**
 * Tests Pinto objects outside of discovery.
 *
 * Which are added to PintoMapping via `pinto.lists` parameter.
 *
 * @group pinto
 */
final class PintoNonDiscoveryTest extends KernelTestBase {

  protected static $modules = [
    'pinto_test',
    'pinto',
  ];

  /**
   * Test objects in definitions.
   *
   * Tests item without a #[Definition].
   *
   * @see \Drupal\pinto_test\Pinto\Generic\ObjectThemeDefinitionClass
   */
  public function testNonDiscovery(): void {
    // We want loose comparison.
    // @phpstan-ignore-next-line
    static::assertTrue(\in_array(
      ObjectListEnumResource::createFromEnum(NonDiscovery::NonDiscoveryObject),
      \iterator_to_array(static::pintoMapping()->getResources()),
      strict: FALSE,
    ));
  }

  public function register(ContainerBuilder $container): void {
    parent::register($container);

    $container->setParameter('pinto.lists', [
      NonDiscovery::class,
    ]);
  }

  private static function pintoMapping(): PintoMapping {
    /** @var \Pinto\PintoMapping */
    return \Drupal::service(PintoMapping::class);
  }

}
