<?php

declare(strict_types=1);

namespace Drupal\pinto\HookTheme\Exception;

final class PintoBuildDefinitionMismatch extends \Exception {

  /**
   * @phpstan-param class-string $objectClassName
   * @phpstan-param string[] $missingKeys
   */
  public function __construct(
    string $objectClassName,
    array $missingKeys,
    ?\Throwable $previous = NULL,
  ) {
    parent::__construct(\sprintf(
          'Build for %s is missing keys: %s', $objectClassName,
          \implode(', ', $missingKeys),
      ), 0, $previous);
  }

}
