<?php

declare(strict_types=1);

namespace Drupal\pinto\Object;

use Pinto\Object\ObjectTrait;
use Pinto\PintoMapping;

trait DrupalObjectTrait {

  use ObjectTrait {
    pintoBuild as originalPintoBuild;
  }

  private function pintoBuild(callable $wrapper): mixed {
    $built = $this->originalPintoBuild($wrapper);
    return PintoToDrupalBuilder::transform($built, static::$pintoResource[static::class]);
  }

  /**
   * Use a mapping pre-made in the container.
   *
   * @internal
   */
  private function pintoMapping(): PintoMapping {
    return self::pintoMappingStatic();
  }

  /**
   * Use a mapping pre-made in the container.
   *
   * @internal
   */
  private static function pintoMappingStatic(): PintoMapping {
    /** @var \Pinto\PintoMapping */
    return \Drupal::service(PintoMapping::class);
  }

}
