<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\DependencyOn;

use Drupal\pinto\Resource\DrupalLibraryInterface;
use Pinto\Attribute\Asset\Css;
use Pinto\Attribute\Asset\Js;
use Pinto\Attribute\DependencyOn;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;

use function Safe\realpath;

enum PintoListDependencies: string implements ObjectListInterface, DrupalLibraryInterface {
  use ObjectListTrait;

  /**
   * Tests multiple are merged.
   */
  #[DependencyOn(self::Beta)]
  #[DependencyOn(self::Charlie)]
  case Alpha = 'alpha';

  #[Css('styles.css')]
  #[Js('app.js')]
  #[DependencyOn(self::Charlie)]
  case Beta = 'beta';

  #[Js('app.js')]
  case Charlie = 'charlie';

  #[DependencyOn(self::Alpha)]
  #[DependencyOn('foo/bar')]
  case Delta = 'delta';

  public function templateDirectory(): string {
    throw new \LogicException('Not tested.');
  }

  public function cssDirectory(): string {
    return realpath(__DIR__ . '/../../../css');
  }

  public function jsDirectory(): string {
    return realpath(__DIR__ . '/../../../js');
  }

  public function libraryName(): string {
    return $this->value;
  }

  public function attachLibraries(): array {
    return [
      \sprintf('pinto/%s', $this->libraryName()),
    ];
  }

}
