<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Generic;

use Drupal\pinto\Attribute\ObjectType\ThemeDefinition;
use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\Asset\Css;
use Pinto\Attribute\Asset\Js;

/**
 * All purpose test object.
 */
#[Css('styles.css')]
#[Js('app.js')]
final class Generic {

  use DrupalObjectTrait;

  /**
   * Constructor.
   */
  private function __construct(
    readonly string $text,
  ) {
  }

  /**
   * Creates a new object.
   */
  public static function create(
    string $text,
  ): static {
    return new static($text);
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (array $build): mixed {
      return $build + [
        '#test_text' => $this->text,
      ];
    });
  }

  #[ThemeDefinition]
  public static function theme(): array {
    return [
      'variables' => [
        'test_text' => NULL,
      ],
    ];
  }

}
