<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Traits;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\Slots\Build;

#[Slots]
final class DrupalObjectTraitObject {

  use DrupalObjectTrait;

  public function __construct(
    private readonly string $text,
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('text', $this->text);
    });
  }

}
