<?php

declare(strict_types=1);

namespace Drupal\pinto\Build;

use Pinto\Resource\ResourceInterface;
use Pinto\Slots\Build;

/**
 * @internal
 */
final class BuildData {

  private function __construct(
    public readonly ResourceInterface $resource,
    public readonly Build $built,
  ) {
  }

  public static function createBuildData(
    ResourceInterface $resource,
    Build $built,
  ): static {
    return new static($resource, $built);
  }

}
