<?php

declare(strict_types=1);

namespace Drupal\pinto\Object;

use Drupal\pinto\Element\PintoComponentElement;
use Pinto\Resource\ResourceInterface;
use Pinto\Slots;

/**
 * Transforms Pinto-lib specific builds to Drupal render arrays.
 *
 * @internal
 *   For internal use only.
 */
final class PintoToDrupalBuilder {

  public static function transform(mixed $built, ResourceInterface $resource): mixed {
    // Transform \Pinto\Attribute\ObjectType\Slots build to Drupal render array.
    if (\is_array($built) && \array_key_exists('#theme', $built)) {
      return $built;
    }

    return ($built instanceof Slots\Build)
      ? PintoComponentElement::renderArray($built, $resource)
      : throw new \LogicException('Unhandled render');
  }

  public static function unitEnumToHookThemeVariableName(\UnitEnum|string $unitEnumOrString): string {
    if ($unitEnumOrString instanceof \UnitEnum) {
      // An enum case name is always valid.
      return $unitEnumOrString->name;
    }

    // According to hook_theme() docs a valid hook_theme variable name must be
    // both a valid PHP and Twig variable name:
    // "(so they must be legal PHP/Twig variable names)".
    return \preg_replace(
      // See also Lexer::REGEX_NAME.
      '/[^a-zA-Z0-9_]/',
      '',
      $unitEnumOrString,
    ) ?? throw new \Exception('Failed to transform to variable name.');
  }

}
