<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Nested;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\Slots\Build;

/**
 * Test object.
 */
#[Slots(slots: ['inner'])]
final class ObjectNested {

  use DrupalObjectTrait;

  public function __invoke(): mixed {
    return $this->pintoBuild(static function (Build $build): Build {
      return $build->set('inner', ObjectNestedInner::create('Nested inner text!'));
    });
  }

}
