<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Standalone\StandaloneDefault;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_test\Pinto\DependencyOn\PintoListDependencies;
use Pinto\Attribute\DependencyOn;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\Slots\Build;

/**
 * A component not in a list.
 *
 * Added to discovery since it has a ObjectTypeInterface attribute, and is not referenced by a list.
 */
#[Slots]
#[DependencyOn(PintoListDependencies::Charlie)]
final class Standalone {

  use DrupalObjectTrait;

  public function __construct(
    readonly string $text,
    readonly int $number = 3,
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('text', $this->text)
        ->set('number', $this->number);
    });
  }

}
