<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\StreamWrapper;

use Drupal\pinto\List\StreamWrapperAssetInterface;
use Drupal\pinto\List\StreamWrapperAssetTrait;
use Pinto\Attribute\Definition;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;
use function Safe\realpath;

/**
 * Defines objects to test stream wrapper.
 */
enum StreamWrapper implements ObjectListInterface, StreamWrapperAssetInterface {

  use ObjectListTrait;
  use StreamWrapperAssetTrait;

  #[Definition(AssetStreamWrapper::class)]
  case StreamWrapper;

  public function templateName(): string {
    // Not tested.
    return $this->name;
  }

  public function templateDirectory(): string {
    return '@pinto_test/templates/stream-wrapper/';
  }

  public function absoluteCssDirectory(): string {
    return realpath(__DIR__ . '/../../../css');
  }

  public function absoluteJsDirectory(): string {
    return realpath(__DIR__ . '/../../../js');
  }

}
