<?php

declare(strict_types=1);

namespace Drupal\Tests\pinto\Kernel;

use Drupal\Core\Render\RendererInterface;
use Drupal\KernelTests\KernelTestBase;
use Drupal\pinto\Build\BuildToken;
use Drupal\pinto\Element\PintoComponentElement;
use Drupal\pinto_test\Pinto\Traits\DrupalInvokableSlotsTraitObject;

/**
 * Tests the DX traits.
 *
 * @group pinto
 */
final class PintoTraitsTest extends KernelTestBase {

  protected static $modules = [
    'pinto_test',
    'pinto',
  ];

  /**
   * @see \Drupal\pinto\Object\DrupalObjectTrait
   */
  public function testDrupalObjectTrait(): void {
    $text = $this->randomMachineName();
    $obj = new DrupalInvokableSlotsTraitObject($text);
    $built = $obj();
    static::assertEquals(PintoComponentElement::class, $built['#type']);
    static::assertInstanceOf(BuildToken::class, $built['#buildToken']);
    static::assertStringContainsString($text, (string) static::renderer()->renderRoot($built));
  }

  /**
   * @see \Drupal\pinto\Object\DrupalInvokableSlotsTrait
   */
  public function testDrupalInvokableSlotsTrait(): void {
    $text = $this->randomMachineName();
    $obj = new DrupalInvokableSlotsTraitObject($text);
    $built = $obj();
    static::assertEquals(PintoComponentElement::class, $built['#type']);
    static::assertInstanceOf(BuildToken::class, $built['#buildToken']);
    static::assertStringContainsString($text, (string) static::renderer()->renderRoot($built));
  }

  public static function renderer(): RendererInterface {
    return \Drupal::service(RendererInterface::class);
  }

}
